{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 11.09.98 - 18:24:08 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMUtils, MMHTimer, StdCtrls, MMObj, MMCstDlg, MMDIBCv, MMLevel, MMConect,
  MMDesign, MMRingBf, MMDSPObj, MMWavOut, MMWave, ExtCtrls,
  MMHook, MMDSWOut, MMPLoad, MMAudio, MMLEDS;

type
  TMainForm = class(TForm)
    WaveOut1: TMMWaveOut;
    RingBuffer1: TMMRingBuffer;
    MMDesigner1: TMMDesigner;
    Connector1: TMMConnector;
    Level1: TMMLevel;
    Level2: TMMLevel;
    OpenDialog: TMMWaveOpenDialog;
    btnStart: TButton;
    btnStop: TButton;
    btnFile: TButton;
    Label1: TLabel;
    lblPosition: TLabel;
    Timer: TMMHiTimer;
    PlayListBox: TListBox;
    Preloader1: TMMPreloader;
    Preloader2: TMMPreloader;
    RingBuffer2: TMMRingBuffer;
    WaveOut2: TMMWaveOut;
    Connector2: TMMConnector;
    PreloadTimer: TTimer;
    AudioFile1: TMMAudioFile;
    AudioFile2: TMMAudioFile;
    procedure TimerTimer(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOut1Start(Sender: TObject);
    procedure WaveOut1Stop(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOut1Close(Sender: TObject);
    procedure WaveOut2Start(Sender: TObject);
    procedure WaveOut2Stop(Sender: TObject);
    procedure WaveOut2Close(Sender: TObject);
    procedure PreloadTimerTimer(Sender: TObject);
  public
    LoadIndex,PlayIndex: integer;
    Stopping: Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Stopping := True;
   WaveOut1.Close;
   WaveOut2.Close;

   Preloader1.Close;
   Preloader2.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
begin
   if (wosOpen in Waveout1.State) then
       lblPosition.Caption := TimeToString(WaveOut1.Position)
   else
       lblPosition.Caption := TimeToString(WaveOut2.Position);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   Stopping := False;

   LoadIndex := 0;
   PlayIndex := 0;

   AudioFile1.FileName := PlayListBox.Items[LoadIndex];
   PlayListBox.ItemIndex := LoadIndex;
   inc(LoadIndex);

   Preloader1.PreloadSize := RingBuffer1.BufferSize*RingBuffer1.NumBuffers;
   Preloader2.PreloadSize := RingBuffer2.BufferSize*RingBuffer2.NumBuffers;

   WaveOut1.Start;

   Timer.Enabled := True;

   btnFile.Enabled := False;
   btnStart.Enabled := False;
   btnStop.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   Stopping := True;
   WaveOut1.Close;
   WaveOut2.Close;

   { if we have already preloaded data but not played yet, }
   { then the Preloader might be open, close it            }
   Preloader1.Close;
   Preloader2.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut1Start(Sender: TObject);
begin
   { start preloading of the next file (WaveOut 2) }
   PreloadTimer.Tag := 2;
   PreloadTimer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut1Stop(Sender: TObject);
begin
   { close the file and device here so we can go to the next file }
   WaveOut1.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut1Close(Sender: TObject);
begin
   { the files was done... }

   { start the next file on the other WaveOut }
   if not Stopping and not AudioFile2.Empty then
   begin
      WaveOut2.Start;

      { update the ListBox }
      inc(PlayIndex);
      PlayListBox.ItemIndex := PlayIndex;
   end
   else
   begin
      Timer.Enabled := False;
      btnStart.Enabled := True;
      btnStop.Enabled := False;
   end;

   { unload the file }
   AudioFile1.FileName := '';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut2Start(Sender: TObject);
begin
   { start preloading of the next file (WaveOut 1) }
   PreloadTimer.Tag := 1;
   PreloadTimer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut2Stop(Sender: TObject);
begin
   { close the file and device here so we can go to the next file }
   WaveOut2.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOut2Close(Sender: TObject);
begin
   { the files was done... }

   { start the next file on the other WaveOut }
   if not Stopping and not AudioFile1.Empty then
   begin
      WaveOut1.Start;
      { update the ListBox }
      inc(PlayIndex);
      PlayListBox.ItemIndex := PlayIndex;
   end
   else
   begin
      Timer.Enabled := False;
      btnStart.Enabled := True;
      btnStop.Enabled := False;
   end;

   { unload the file }
   AudioFile2.FileName := '';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   { setup a simple playlist so we can demonstrate how to handle it }
   if OpenDialog.Execute then
   begin
      PlayListBox.Items.Add(OpenDialog.FileName);
      if not btnStop.Enabled then btnStart.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PreloadTimerTimer(Sender: TObject);
begin
   { other files to play ??? }
   if LoadIndex < PlayListBox.Items.Count then
   begin
      { set the next file }
      if PreloadTimer.Tag = 1 then
      begin
         AudioFile1.FileName := PlayListBox.Items[LoadIndex];
         Preloader1.Preload;
      end
      else
      begin
         AudioFile2.FileName := PlayListBox.Items[LoadIndex];
         Preloader2.Preload;
      end;

      inc(LoadIndex);
   end
   else Stopping := True;

   PreloadTimer.Enabled := False;
end;

end.
